# PhotoSwipe 5.4.4 Assets

This folder contains the PhotoSwipe lightbox library files downloaded from CDN.

## Files Overview

### CSS
- **photoswipe.min.css** (4.6 KB)
  - Core PhotoSwipe styles
  - Required for basic lightbox functionality

### JavaScript - UMD Format (Universal Module Definition)
- **photoswipe.umd.min.js** (54 KB)
  - Core PhotoSwipe library (UMD format)
  - Works with traditional `<script>` tags
  - **Currently used by the plugin**

- **photoswipe-lightbox.umd.min.js** (15 KB)
  - PhotoSwipe lightbox module (UMD format)
  - Works with traditional `<script>` tags
  - **Currently used by the plugin**

### JavaScript - ESM Format (ECMAScript Modules)
- **photoswipe.esm.min.js** (53 KB)
  - Core PhotoSwipe library (ESM format)
  - For modern JavaScript module imports
  - Use with `import` statements

- **photoswipe-lightbox.esm.min.js** (15 KB)
  - PhotoSwipe lightbox module (ESM format)
  - For modern JavaScript module imports
  - Use with `import` statements

## Which Format to Use?

### UMD Format (Currently Implemented)
```php
// In PHP (WordPress):
wp_enqueue_script('photoswipe', 'path/to/photoswipe.umd.min.js');
wp_enqueue_script('photoswipe-lightbox', 'path/to/photoswipe-lightbox.umd.min.js');
```

```javascript
// In JavaScript:
var lightbox = new PhotoSwipeLightbox({ ... });
```

**✅ Best for:**
- WordPress plugins
- Traditional web applications
- Browser compatibility
- No build process required

### ESM Format (Alternative)
```javascript
// In JavaScript with module bundler:
import PhotoSwipeLightbox from './photoswipe-lightbox.esm.min.js';
import PhotoSwipe from './photoswipe.esm.min.js';

const lightbox = new PhotoSwipeLightbox({ ... });
```

**✅ Best for:**
- Modern JavaScript applications
- Projects using bundlers (Webpack, Vite, etc.)
- ES6+ module syntax
- Tree-shaking optimization

## Current Plugin Usage

The Smart Gallery Optimizer plugin uses **UMD format** files:
- `photoswipe.umd.min.js`
- `photoswipe-lightbox.umd.min.js`
- `photoswipe.min.css`

These files are loaded in:
- `includes/class-lightbox-handler.php` (lines 95-118)
- `assets/js/lightbox-init.js` (initialization)

## Source

All files downloaded from: https://cdnjs.cloudflare.com/ajax/libs/photoswipe/5.4.4/

## License

PhotoSwipe is licensed under the MIT License.
Copyright (c) Dmytro Semenov
https://photoswipe.com

## Version

**PhotoSwipe 5.4.4**
