<?php
/**
 * Admin Settings Page Template
 *
 * @package Smart_Gallery_Optimizer
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="wrap sgo-admin-wrap">
	<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>

	<?php
	// Display success message if settings updated
	// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- WordPress core handles settings nonce
	if ( isset( $_GET['settings-updated'] ) && '1' === $_GET['settings-updated'] ) {
		add_settings_error(
			'sgo_messages',
			'sgo_message',
			__( 'Settings saved successfully.', 'smart-gallery-optimizer' ),
			'updated'
		);
	}

	// Display settings errors
	settings_errors( 'sgo_messages' );
	?>

	<div class="sgo-admin-container">
		<div class="sgo-admin-main">
			<div class="sgo-card">
				<div class="sgo-card-header">
					<h2><?php esc_html_e( 'Conversion Settings', 'smart-gallery-optimizer' ); ?></h2>
					<p class="description">
						<?php esc_html_e( 'Configure automatic image format conversion for uploaded images. The plugin will convert JPEG and PNG images while preserving the original files.', 'smart-gallery-optimizer' ); ?>
					</p>
				</div>

				<div class="sgo-card-body">
					<form method="post" action="options.php">
						<?php
						// Output security fields
						settings_fields( 'sgo_settings_group' );

						// Output settings sections
						do_settings_sections( 'smart-gallery-optimizer' );

						// Output submit button
						submit_button( __( 'Save Settings', 'smart-gallery-optimizer' ) );
						?>
					</form>
				</div>
			</div>

			<!-- Statistics Card (Placeholder for Milestone 1) -->
			<div class="sgo-card">
				<div class="sgo-card-header">
					<h2><?php esc_html_e( 'Statistics', 'smart-gallery-optimizer' ); ?></h2>
				</div>
				<div class="sgo-card-body">
					<div class="sgo-stats-grid">
						<?php
						// Count converted images
						$upload_dir = wp_upload_dir();
						$basedir = $upload_dir['basedir'];

						$webp_count = 0;
						$avif_count = 0;

						if ( is_dir( $basedir ) ) {
							// Use RecursiveIteratorIterator to count files recursively
							try {
								$directory = new RecursiveDirectoryIterator( $basedir, RecursiveDirectoryIterator::SKIP_DOTS );
								$iterator = new RecursiveIteratorIterator( $directory );

								foreach ( $iterator as $file ) {
									if ( $file->isFile() ) {
										$extension = strtolower( $file->getExtension() );
										if ( $extension === 'webp' ) {
											$webp_count++;
										} elseif ( $extension === 'avif' ) {
											$avif_count++;
										}
									}
								}
							} catch ( Exception $e ) {
								// Silently fail if directory can't be read
								if ( defined( 'WP_DEBUG' ) && WP_DEBUG ) {
									error_log( 'SGO: Error counting images - ' . $e->getMessage() );
								}
							}
						}
						?>
						<div class="sgo-stat-item">
							<div class="sgo-stat-label"><?php esc_html_e( 'WebP Images', 'smart-gallery-optimizer' ); ?></div>
							<div class="sgo-stat-value"><?php echo esc_html( number_format( $webp_count ) ); ?></div>
						</div>
						<div class="sgo-stat-item">
							<div class="sgo-stat-label"><?php esc_html_e( 'AVIF Images', 'smart-gallery-optimizer' ); ?></div>
							<div class="sgo-stat-value"><?php echo esc_html( number_format( $avif_count ) ); ?></div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<!-- Sidebar -->
		<div class="sgo-admin-sidebar">
			<!-- About Card -->
			<div class="sgo-card">
				<div class="sgo-card-header">
					<h3><?php esc_html_e( 'About', 'smart-gallery-optimizer' ); ?></h3>
				</div>
				<div class="sgo-card-body">
					<p><?php esc_html_e( 'Smart Gallery Optimizer automatically converts your images to modern formats for better performance and SEO.', 'smart-gallery-optimizer' ); ?></p>
					<p><strong><?php esc_html_e( 'Version:', 'smart-gallery-optimizer' ); ?></strong> <?php echo esc_html( SGO_VERSION ); ?></p>
				</div>
			</div>

			<!-- How It Works Card -->
			<div class="sgo-card">
				<div class="sgo-card-header">
					<h3><?php esc_html_e( 'How It Works', 'smart-gallery-optimizer' ); ?></h3>
				</div>
				<div class="sgo-card-body">
					<ol class="sgo-how-it-works">
						<li><?php esc_html_e( 'Upload images via WordPress media library', 'smart-gallery-optimizer' ); ?></li>
						<li><?php esc_html_e( 'Plugin automatically converts to WebP/AVIF', 'smart-gallery-optimizer' ); ?></li>
						<li><?php esc_html_e( 'Original images are preserved as fallback', 'smart-gallery-optimizer' ); ?></li>
						<li><?php esc_html_e( 'Modern browsers load optimized formats', 'smart-gallery-optimizer' ); ?></li>
						<li><?php esc_html_e( 'Older browsers use original images', 'smart-gallery-optimizer' ); ?></li>
					</ol>
				</div>
			</div>

			<!-- Browser Support Card -->
			<div class="sgo-card">
				<div class="sgo-card-header">
					<h3><?php esc_html_e( 'Browser Support', 'smart-gallery-optimizer' ); ?></h3>
				</div>
				<div class="sgo-card-body">
					<p><strong>WebP:</strong></p>
					<ul class="sgo-browser-list">
						<li><span class="dashicons dashicons-yes-alt"></span> Chrome 23+</li>
						<li><span class="dashicons dashicons-yes-alt"></span> Firefox 65+</li>
						<li><span class="dashicons dashicons-yes-alt"></span> Safari 14+</li>
						<li><span class="dashicons dashicons-yes-alt"></span> Edge 18+</li>
					</ul>
					<p><strong>AVIF:</strong></p>
					<ul class="sgo-browser-list">
						<li><span class="dashicons dashicons-yes-alt"></span> Chrome 85+</li>
						<li><span class="dashicons dashicons-yes-alt"></span> Firefox 93+</li>
						<li><span class="dashicons dashicons-yes-alt"></span> Safari 16+</li>
						<li><span class="dashicons dashicons-yes-alt"></span> Edge 121+</li>
					</ul>
				</div>
			</div>
		</div>
	</div>
</div>
