# Smart Gallery Optimizer

**Version:** 1.0.0
**Author:** Sabibur Rahman
**License:** GPL v2 or later
**Requires WordPress:** 5.0+
**Requires PHP:** 8.0+

A comprehensive WordPress plugin that enhances gallery performance through automatic image optimization, responsive layouts, and advanced SEO features.

---

## Table of Contents

- [Overview](#overview)
- [Key Features](#key-features)
- [Installation](#installation)
- [Quick Start](#quick-start)
- [Core Features](#core-features)
- [Shortcode Documentation](#shortcode-documentation)
- [Admin Dashboard](#admin-dashboard)
- [Browser Support](#browser-support)
- [System Requirements](#system-requirements)
- [FAQ](#faq)
- [Support](#support)
- [License](#license)

---

## Overview

Smart Gallery Optimizer is a powerful WordPress plugin designed to improve your website's performance and SEO by automatically converting images to modern formats (WebP/AVIF), implementing lazy loading, and providing feature-rich responsive galleries with lightbox support.

**Why Choose Smart Gallery Optimizer?**

- **Performance:** Reduce image file sizes by 30-50% with WebP/AVIF conversion
- **SEO:** Automatic alt-text generation from EXIF data improves search rankings
- **User Experience:** Responsive galleries with PhotoSwipe lightbox
- **Easy to Use:** Simple shortcode interface and visual gallery manager
- **Developer Friendly:** Hooks and filters for customization

---

## Key Features

### Image Optimization

- **Automatic WebP Conversion** - Convert JPEG/PNG to WebP on upload
- **AVIF Support** - Generate AVIF images for superior compression (PHP 8.1+)
- **Quality Control** - Adjustable quality settings (1-100)
- **Original Preservation** - Keeps original files for browser fallback
- **Server Detection** - Automatically detects server capabilities

### Performance & Display

- **Lazy Loading** - Load images only when visible (Intersection Observer API)
- **Responsive Grid** - CSS Grid layout with 2-6 column support
- **Mobile Optimized** - Automatic responsive breakpoints
- **Conditional Assets** - CSS/JS only load when needed
- **Smart Fallback** - Uses WordPress default gallery if disabled

### Gallery Management

- **Gallery Manager** - Save, edit, delete, and duplicate galleries
- **PhotoSwipe Lightbox** - Modern touch-friendly lightbox
- **Link Behavior Options** - None, direct link, or lightbox
- **Custom Settings** - Per-gallery columns, size, gap, and link settings
- **One-Click Shortcode** - Copy gallery shortcode instantly

### EXIF & SEO

- **EXIF Data Extraction** - Read camera, date, and GPS data
- **Auto Alt-Text** - Generate alt-text from EXIF, title, or filename
- **Bulk Alt-Text Generator** - Process existing images without alt-text
- **Customizable Template** - Define alt-text format with variables
- **SEO Optimized** - Improve image search rankings

---

## Installation

### Step 1: Upload Plugin

1. Download the `smart-gallery-optimizer` plugin folder
2. Upload to `/wp-content/plugins/` directory via FTP or WordPress admin
3. Or use WordPress **Plugins > Add New > Upload Plugin**

### Step 2: Activate

1. Go to **Plugins** menu in WordPress admin
2. Find "Smart Gallery Optimizer"
3. Click **Activate**

### Step 3: Configure

1. Navigate to **Smart Gallery** in admin sidebar
2. Configure your preferred settings
3. Start uploading images!

**See [INSTALLATION-GUIDE.md](INSTALLATION-GUIDE.md) for detailed installation instructions.**

---

## Quick Start

### Create Your First Gallery

**Method 1: Using Gallery Manager (Recommended)**

1. Go to **Smart Gallery > Gallery List** in admin
2. Click **Create New Gallery**
3. Add a gallery name
4. Click **Add Images** and select from media library
5. Configure settings (columns, size, gap, link behavior)
6. Click **Save Gallery**
7. Copy the generated shortcode: `[smart_gallery id="123"]`
8. Paste into any page or post

**Method 2: Using Legacy Shortcode**

```
[smart_gallery ids="1,2,3,4,5,6" columns="3" size="medium" gap="20"]
```

Replace `ids` with your image attachment IDs.

---

## Core Features

### 1. Image Conversion

**How It Works:**

1. Upload any JPEG or PNG image through WordPress Media Library
2. Plugin automatically creates WebP version (and AVIF if enabled)
3. Original image is preserved as fallback
4. Modern browsers receive optimized formats (30-50% smaller)
5. Older browsers receive original images

**Settings:**

- **WebP Conversion:** Enable/Disable, Quality 1-100 (default: 85)
- **AVIF Conversion:** Enable/Disable, Quality 1-100 (default: 85)
- **Server Detection:** Shows supported formats in admin

**Performance Benefits:**

- WebP: 25-35% smaller than JPEG
- AVIF: 30-50% smaller than JPEG
- Faster page load times
- Reduced bandwidth usage

### 2. Lazy Loading

**How It Works:**

- Images load only when they appear in the viewport
- Uses Intersection Observer API (modern browser standard)
- Loads images 200px before they're visible for smooth experience
- Fallback to immediate loading if JavaScript is disabled

**Settings:**

- **Enable Lazy Loading:** Toggle On/Off
- Works with both `[smart_gallery]` and standard WordPress images

### 3. Responsive Galleries

**Responsive Behavior:**

| Screen Size | Default Behavior |
|-------------|------------------|
| **Desktop (>1024px)** | Uses your specified column count (2-6) |
| **Tablet (768-1024px)** | 2-3 columns stay same, 4+ reduce to 2 |
| **Mobile (<768px)** | ALL layouts become single column |

**Settings:**

- **Enable Smart Grid:** Toggle On/Off
- **Default Columns:** 2-6 (default: 3)

### 4. Gallery Manager

**Features:**

- **Save Galleries:** Create reusable galleries with names
- **Edit Galleries:** Modify images, settings anytime
- **Delete Galleries:** Remove unwanted galleries
- **Duplicate Galleries:** Clone existing galleries
- **Drag & Drop:** Reorder images visually
- **Preview:** See thumbnails before saving

**Access:** **Smart Gallery > Gallery List**

### 5. PhotoSwipe Lightbox

**Features:**

- Modern, touch-friendly lightbox overlay
- Pinch-to-zoom support
- Keyboard navigation (arrows, ESC)
- Gallery navigation (prev/next)
- Optional title and caption display
- Responsive and mobile-optimized

**Settings:**

- **Default Link Type:** None, Direct, or Lightbox
- **Open in New Tab:** For direct links
- **Show Title in Lightbox:** Toggle
- **Show Caption in Lightbox:** Toggle

### 6. EXIF & Alt-Text

**EXIF Data Extracted:**

- Camera make and model
- Date photo was taken
- GPS coordinates (latitude/longitude)
- Image description
- Orientation

**Auto Alt-Text Generation:**

**Priority:**
1. Existing alt-text (if present)
2. EXIF data using template
3. Image title
4. Cleaned filename

**Template Variables:**

- `{description}` - Image description or title
- `{camera}` - Camera make and model
- `{date}` - Date photo was taken
- `{location}` - GPS coordinates

**Bulk Alt-Text Generator:**

- Process up to 100 images at once
- Preview generated alt-text before saving
- Accessible at **Smart Gallery > Bulk Alt-Text**

---

## Shortcode Documentation

### [smart_gallery] Shortcode

#### Using Saved Galleries

```
[smart_gallery id="123"]
```

**Parameters:**
- `id` - Saved gallery ID (from Gallery Manager)
- `columns` - (Optional) Override gallery's default columns
- `size` - (Optional) Override gallery's default image size
- `gap` - (Optional) Override gallery's default gap

#### Using Legacy Format

```
[smart_gallery ids="1,2,3,4,5,6" columns="3" size="medium" gap="20"]
```

**Parameters:**

| Attribute | Required | Default | Values | Description |
|-----------|----------|---------|--------|-------------|
| `id` | No* | - | Number | Saved gallery ID |
| `ids` | No* | - | Comma-separated numbers | Image attachment IDs |
| `columns` | No | 3 | 2-6 | Number of columns |
| `size` | No | medium | thumbnail/medium/large/full | WordPress image size |
| `gap` | No | 20 | 0-100 | Space between images (pixels) |

*Either `id` or `ids` is required

### Shortcode Examples

**Basic 3-Column Gallery:**
```
[smart_gallery ids="23,45,67,89,12,34"]
```

**4-Column Portfolio:**
```
[smart_gallery ids="1,2,3,4,5,6,7,8" columns="4" size="large"]
```

**Product Grid (6 columns, tight spacing):**
```
[smart_gallery ids="1,2,3,4,5,6,7,8,9,10,11,12" columns="6" size="thumbnail" gap="10"]
```

**Before/After Comparison (2 columns, wide gap):**
```
[smart_gallery ids="401,402" columns="2" size="full" gap="40"]
```

**Single Column Full Width:**
```
[smart_gallery ids="23,45,67" columns="1" size="full"]
```

**Using Saved Gallery:**
```
[smart_gallery id="15"]
```

**Saved Gallery with Overrides:**
```
[smart_gallery id="15" columns="4" size="large"]
```

### Finding Image IDs

**Method 1: Media Library URL**
1. Go to **Media > Library**
2. Click on an image
3. Look at browser URL: `post.php?post=123&action=edit`
4. The ID is `123`

**Method 2: Attachment Details**
1. Go to **Media > Library** (Grid view)
2. Click on an image
3. View ID in attachment details sidebar

**Method 3: Using in Templates**

```php
<?php echo do_shortcode('[smart_gallery ids="1,2,3,4" columns="3"]'); ?>
```

---

## Admin Dashboard

### Settings Pages

Access: **Smart Gallery** in WordPress admin sidebar

#### 1. Conversion Settings

**Location:** Smart Gallery > Conversion Settings

- **WebP Conversion:** Toggle + Quality slider (1-100)
- **AVIF Conversion:** Toggle + Quality slider (1-100)
- **Server Capabilities:** Shows GD/Imagick/WebP/AVIF/EXIF support

#### 2. Performance & Display Settings

**Location:** Smart Gallery > Performance & Display Settings

- **Enable Lazy Loading:** Toggle
- **Enable Smart Grid:** Toggle
- **Default Columns:** Dropdown (2-6)

#### 3. EXIF & SEO Settings

**Location:** Smart Gallery > EXIF & SEO Settings

- **Enable Auto Alt-Text:** Toggle
- **Include Camera Info:** Toggle
- **Include Date Info:** Toggle
- **Include Location Info:** Toggle
- **Alt-Text Template:** Text input with variables

#### 4. Link Behavior Settings

**Location:** Smart Gallery > Link Behavior Settings

- **Default Link Type:** Radio buttons (None/Direct/Lightbox)
- **Open Direct Links in New Tab:** Toggle
- **Show Title in Lightbox:** Toggle
- **Show Caption in Lightbox:** Toggle

### Gallery Manager

**Access:** **Smart Gallery > Gallery List**

**Features:**

- Create new galleries
- Edit existing galleries
- Delete galleries (with confirmation)
- Duplicate galleries
- Copy shortcode to clipboard
- View image count and settings
- Search and pagination

**Gallery Editor:**

- Name your gallery
- Add/remove images with media library
- Drag-and-drop to reorder images
- Set columns (2-6)
- Choose image size (thumbnail/medium/large/full)
- Set gap spacing (0-100px)
- Configure link type (none/direct/lightbox)
- Toggle lightbox title/caption
- Preview before saving

### Bulk Alt-Text Generator

**Access:** **Smart Gallery > Bulk Alt-Text**

**Features:**

- Finds all images without alt-text (up to 100)
- Preview generated alt-text before applying
- Batch process with one click
- Uses EXIF data, title, or filename
- Shows thumbnail preview
- Real-time status updates

---

## Browser Support

### WebP Support

- Chrome 23+
- Firefox 65+
- Safari 14+
- Edge 18+
- Opera 12.1+

### AVIF Support

- Chrome 85+
- Firefox 93+
- Safari 16+
- Edge 121+

### Lazy Loading (Intersection Observer)

- All modern browsers (95%+ global support)
- Automatic fallback for older browsers

---

## System Requirements

### Minimum Requirements

- **WordPress:** 5.0 or higher
- **PHP:** 8.0 or higher
- **GD Library:** With WebP support
- **Memory:** 128MB (256MB recommended)

### Recommended Requirements

- **WordPress:** 6.0 or higher
- **PHP:** 8.1 or higher (for AVIF support)
- **GD Library or Imagick:** With WebP and AVIF support
- **Memory:** 256MB or higher
- **Server:** Apache or Nginx

### Check Server Capabilities

Go to **Smart Gallery > Conversion Settings** to see:

- GD Library (Required for image processing)
- ImageMagick (Alternative to GD)
- WebP Support (Required for WebP conversion)
- AVIF Support (Required for AVIF conversion)
- EXIF Support (Required for EXIF data extraction)

---

## FAQ

### General Questions

**Q: Will this work with my theme?**
A: Yes! Smart Gallery Optimizer works with all standard WordPress themes and page builders (Elementor, Gutenberg, WPBakery, etc.).

**Q: Do I need to reconvert old images?**
A: Images uploaded before activation are not automatically converted. Only new uploads are converted. Bulk conversion may be added in future updates.

**Q: Will this slow down my site?**
A: No! The plugin actually improves performance by reducing image file sizes and implementing lazy loading. Assets only load on pages with galleries.

### Image Conversion

**Q: What happens to my original images?**
A: Original images are always preserved. WebP/AVIF versions are created alongside originals for fallback compatibility.

**Q: Can I disable WebP/AVIF after converting images?**
A: Yes, but converted files will remain on server. You can manually delete WebP/AVIF files if needed.

**Q: Why isn't AVIF working?**
A: AVIF requires PHP 8.1+ with GD library and AVIF support. Check **Settings > Smart Gallery** for server capabilities.

### Galleries & Shortcodes

**Q: Can I have multiple galleries on one page?**
A: Yes! Use multiple `[smart_gallery]` shortcodes on the same page.

**Q: How do I find image attachment IDs?**
A: Go to Media Library, click an image, and look at the URL. The ID is the number in `post=123`.

**Q: Can I disable the smart grid?**
A: Yes! Go to **Settings > Smart Gallery > Performance & Display** and toggle "Enable Smart Grid" off. It will fallback to WordPress default gallery.

### Lazy Loading

**Q: Does lazy loading work without JavaScript?**
A: If JavaScript is disabled, images load immediately as fallback.

**Q: Can I disable lazy loading for specific galleries?**
A: Currently, lazy loading is a global setting. You can disable it in **Settings > Smart Gallery > Performance & Display**.

### EXIF & Alt-Text

**Q: Will auto alt-text override existing alt-text?**
A: No! The plugin only generates alt-text for images that don't have it.

**Q: Can I customize the alt-text template?**
A: Yes! Go to **Settings > Smart Gallery > EXIF & SEO** and modify the template using variables like `{camera}`, `{date}`, etc.

**Q: Does EXIF extraction work for all images?**
A: EXIF data is only available in JPEG files from cameras/phones. PNG, GIF, and edited images may not have EXIF data.

### Lightbox

**Q: Can I use my own lightbox plugin?**
A: Yes! Set **Default Link Type** to "None" or "Direct" and use your preferred lightbox plugin.

**Q: How do I disable the lightbox?**
A: Go to **Settings > Smart Gallery > Link Behavior** and set **Default Link Type** to "None" or "Direct".

### Troubleshooting

**Q: Images not converting to WebP/AVIF?**
**Check:**
- WebP/AVIF enabled in settings
- Server has GD library with WebP support
- PHP 8.1+ for AVIF
- Images are JPEG or PNG (not GIF/SVG)

**Q: Shortcode displays nothing?**
**Check:**
- Image IDs are correct and exist
- Smart Grid is enabled in settings
- Images are published (not draft)
- Browser console for JavaScript errors

**Q: Lazy loading not working?**
**Check:**
- Lazy Loading is enabled in settings
- Browser supports Intersection Observer
- JavaScript is not blocked
- Console for errors

**Q: Gallery not responsive?**
**Check:**
- Clear browser cache
- Verify `frontend-style.css` is loading
- Check if theme CSS is overriding gallery styles

---

## Support

### Documentation

- **Installation Guide:** [INSTALLATION-GUIDE.md](INSTALLATION-GUIDE.md)
- **User Guide:** [USER-GUIDE.md](USER-GUIDE.md)
- **Developer Guide:** [DEVELOPER-GUIDE.md](DEVELOPER-GUIDE.md)
- **Changelog:** [CHANGELOG.md](CHANGELOG.md)

### Getting Help

For support, feature requests, or bug reports:

- **Author:** Sabibur Rahman
- **Fiverr:** [https://www.fiverr.com/sabibur](https://www.fiverr.com/sabibur)
- **Plugin URI:** [https://example.com/smart-gallery-optimizer](https://example.com/smart-gallery-optimizer)

### Reporting Issues

When reporting issues, please include:

1. WordPress version
2. PHP version
3. Active theme and plugins
4. Error messages (if any)
5. Steps to reproduce the issue

---

## Credits

**Developed by:** Sabibur Rahman
**Version:** 1.0.0
**License:** GPL v2 or later

### Third-Party Libraries

- **PhotoSwipe** v5.4.4 - [https://photoswipe.com](https://photoswipe.com) (MIT License)
- **Intersection Observer API** - Native browser API

---

## License

This plugin is licensed under the GPL v2 or later.

```
Smart Gallery Optimizer WordPress Plugin
Copyright (C) 2024 Sabibur Rahman

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
```

Full license: [https://www.gnu.org/licenses/gpl-2.0.html](https://www.gnu.org/licenses/gpl-2.0.html)

---

## What's Next?

After installing and configuring Smart Gallery Optimizer:

1. Upload some images to test WebP/AVIF conversion
2. Create your first gallery using Gallery Manager
3. Add the gallery shortcode to a page
4. Test on different devices (mobile/tablet/desktop)
5. Run Bulk Alt-Text Generator for existing images
6. Check your page load speed improvement

**Thank you for choosing Smart Gallery Optimizer!**
